// Existing services ...

builder.Services.AddRateLimiter(options =>
{
  options.GlobalLimiter = PartitionedRateLimiter.Create<HttpContext, string>(httpContext =>
    RateLimitPartition.GetFixedWindowLimiter(
      partitionKey: httpContext.User.Identity?.Name ?? httpContext.Request.Headers.Host.ToString(),
      factory: partition => new FixedWindowRateLimiterOptions
      {
        AutoReplenishment = true,
        PermitLimit = Convert.ToInt32(builder.Configuration["RateLimit:Limit"]),
        QueueLimit = 0,
        Window = TimeSpan.FromMinutes(Convert.ToDouble(builder.Configuration["RateLimit:WindowInMinutes"])),
      }));
  options.RejectionStatusCode = Convert.ToInt32(builder.Configuration["RateLimit:HttpStatusCode"]);
});

// existing configuration of HTTP request pipeline...

app.UseRouting();
app.UseRateLimiter();